#include "AlphaTransporter.h"

AlphaTransporter::AlphaTransporter(I2C *master)
:   pool(),
    i2c(master)
{
}

bool AlphaTransporter::set()
{
    bool no_error = true;
    
    i2c.transport_begin(JUSHINKUN_ADDR, pool.ctrl.all_data, 10);
    no_error = no_error & i2c.read();
    i2c.transport_end();

    pool.up_load();
    
    return no_error;
}

void AlphaTransporter::write(int index_num, int data)
{
    pool.data_index[index_num] = data;
}   

int AlphaTransporter::read(int index_num)
{
    return pool.data_index[index_num];
}

void AlphaTransporter::reset()
{
    pool.reset();
}
    