#include "mbed.h"
#include "gamma_ctrl.h"
#define I2C_SDA dp5
#define I2C_SCL dp27

DigitalOut read_success_led(LED1);
DigitalOut read_error_led(LED2);
I2CSlave transmit(I2C_SDA,I2C_SCL);
gamma_ctrl twe(115200);
void status_led();
void i2c_send();

int main() 
{
    transmit.address(GAMMA_ADDRESS);
    while(1) 
    {
        twe.get_data();
        status_led();
        i2c_send();
        /*printf("status:%d",twe.error_status);
        printf(",rx:%d,ry:%d,r,%d%d%d%d",twe.pack.data.rx,twe.pack.data.ry,
                                        twe.pack.data.r_sw1,twe.pack.data.r_sw2,
                                        twe.pack.data.r_sw3,twe.pack.data.r_sw4);
        printf("\r\n");*/
        //wait(0.1); //wait変えないで
        wait(0.03);
    }
}

void status_led()
{
    if(twe.error_status == 0)
    {
        read_error_led = 0;
        read_success_led = 1;
    }
    else
    {
        read_error_led = 1;
        read_success_led = 0;
    }
}

void i2c_send()
{
    if(transmit.receive() == I2CSlave::ReadAddressed){
        //read_error_led = 1;
        transmit.write(twe.pack.all_data,GAMMA_DATA_SIZE);
    }//else
        //read_error_led = 0;
}