#include "mbed.h"

#include "DataPool.h"
#include "AlphaTransporter.h"
#include "BoolProcess.h"

#include "ArrowShooter.h"


#define SDA PB_7
#define SCL PB_6

I2C *master;
DataPool *alpha;

Serial pc(USBTX, USBRX);

double fire_work_time;
int fire_work_allow = 0;

int main()
{
    master = new I2C(SDA, SCL);
    alpha = new AlphaTransporter(master);
    ArrowShooter shooter(master);
    while(1)
    {
        alpha->set();
        if(alpha->read(3) == 1)
        {
            fire_work_allow = 1;
        }
        
        if(fire_work_allow == 1)
        {
            fire_work_time = shooter.fire(); 
            fire_work_allow = 1;
        }
        if(fire_work_time >= 3.7)
            fire_work_allow = 0;
            
        //printf("%f\r\n", fire_work_time);
    }
}
