#ifndef ARROW_SHOOTER_H
#define ARROW_SHOOTER_H

#include "mbed.h"

#include "Alpha_ApprI2C_ID.h"
#include "ApprI2CMaster.h"

#include "MotorDriver.h"
#include "ThrowData_MD.h"
#include "CtrlMD.h"


class ArrowShooter
{
    public:
        ArrowShooter(I2C *_master, double _strt_inval = 0.01);
        
        double fire();
        void set_pwm(double pwm, double inval = 0.01);
        
    private:
        ApprI2CMaster to_slave;
        ThrowData i2c_md;
        MotorDriver *_MD;
        CtrlMD motor;
        
        Timer time;
        
};

#endif

