#include "ArrowShooter.h"

ArrowShooter::ArrowShooter(I2C *_master, double _strt_inval)
:   to_slave(alpha_a::sht_pwr, alpha_a::unsig, alpha_a::s2_addr, _master),
    _MD(&i2c_md),
    motor(_MD, _strt_inval)
{
    time.reset();
    time.start();
}

double ArrowShooter::fire()
{
    
    if(2.5 > time.read())
    {
        //printf("ypaaa!!");
        set_pwm(1.0);
    }
    else if(3.8 > time.read())
    {
        set_pwm(0.0);
    }
    else 
    {
        time.reset();
    }        

    
    printf("%d\r\n",i2c_md.get_output());
    
    return time.read(); 
       
}

void ArrowShooter::set_pwm(double pwm, double inval)
{
    motor.reform_inval(inval);
    motor.drive(pwm);
    to_slave.write((uint8_t)i2c_md.get_output());  
}