/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "cc3000.h"
#include "main.h"

#include "UDPSocket.h"

using namespace mbed_cc3000;

/* cc3000 module declaration specific for user's board. Check also init() */
#if (MY_BOARD == WIGO)
cc3000 wifi(PTA16, PTA13, PTD0, SPI(PTD2, PTD3, PTC5), "ssid", "key", WPA2, false);
Serial pc(USBTX, USBRX);
#elif (MY_BOARD == WIFI_DIPCORTEX)
cc3000 wifi(p28, p27, p30, SPI(p21, p14, p37), "ssid", "key", WPA2, false);
Serial pc(UART_TX, UART_RX);
#elif (MY_BOARD == MBED_BOARD_EXAMPLE)
cc3000 wifi(p9, p10, p8, SPI(p5, p6, p7), "ssid", "key", WPA2, false);
Serial pc(USBTX, USBRX);
#else

#endif

/**
 *  \brief UDP server demo
 *  \param  none
 *  \return int
 */
int main() {
    init(); /* board dependent init */
    pc.baud(115200);

    printf("cc3000 UDP server demo. \r\n");
    wifi.init();
    if (wifi.connect() == -1) {
        printf("Failed to connect. Please verify connection details and try again. \r\n");
    } else {
        printf("IP address: %s \r\n", wifi.getIPAddress());
    }
    
    const int ECHO_SERVER_PORT = 1500;

    UDPSocket server;
    server.bind(ECHO_SERVER_PORT);
    
    Endpoint client;
    char buffer[256];
    while (true) {
        printf("\r\nWait for packet...\r\n");
        int n = server.receiveFrom(client, buffer, sizeof(buffer));
        
        printf("Received packet from: %s \r\n", client.get_address());
        server.sendTo(client, buffer, n);
    }
}
