/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MAIN_H
#define MAIN_H

/* use this defines in AP_SECURITY */
#define NONE 0
#define WEP  1
#define WPA  2
#define WPA2 3

// use smart config
#define USE_SMART_CONFIG 0

 // Default SSID Settings
#define AP_KEY       "test"
#define AP_SECURITY     WPA2            // WPA2 must be enabled for use with iPhone or Android phone hotspot!
#define SSID           "test"
/* Board specific */
#define WIGO_BOARD 1

#if (WIGO_BOARD == 1)

#define SET_PWR_EN1    PWR_EN1 = 0
#define SET_PWR_EN2    PWR_EN2 = 1

#define WLAN_ISF_PCR        PORTA->PCR[16]
#define WLAN_ISF_ISFR       PORTA->ISFR
#define WLAN_ISF_MASK       (1<<16)

#define CLEAR_PCR_INTERRUPT    WLAN_ISF_PCR|=PORT_PCR_ISF_MASK;
#define CLEAN_PORT_INTERRUPT   WLAN_ISF_ISFR|=WLAN_ISF_MASK;

#else

#endif

#endif
