/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "cc3000.h"
#include "main.h"

#include "HTTPClient.h"

using namespace mbed_cc3000;

/* cc3000 module declaration specific for user's board. Check also init() */
#if (MY_BOARD == WIGO)
cc3000 wifi(PTA16, PTA13, PTD0, SPI(PTD2, PTD3, PTC5), "ssid", "key", WPA2, false);
Serial pc(USBTX, USBRX);
#elif (MY_BOARD == WIFI_DIPCORTEX)
cc3000 wifi(p28, p27, p30, SPI(p21, p14, p37), "ssid", "key", WPA2, false);
Serial pc(UART_TX, UART_RX);
#elif (MY_BOARD == MBED_BOARD_EXAMPLE)
cc3000 wifi(p9, p10, p8, SPI(p5, p6, p7), "ssid", "key", WPA2, false);
Serial pc(USBTX, USBRX);
#else

#endif

HTTPClient http;
char str[512];
/**
 *  \brief HTTP client demo
 *  \param  none
 *  \return int
 */
int main() {
    init(); /* board dependent init */
    pc.baud(115200);

    printf("cc3000 HTTP client demo. \r\n");
    wifi.init();
    if (wifi.connect() == -1) {
        printf("Failed to connect. Please verify connection details and try again. \r\n");
        while(1);
    } else {
        printf("IP address: %s \r\n",wifi.getIPAddress());
    }
    
    //GET data
    printf("\r\nTrying to fetch page... \r\n");
    int ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }

    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf(" \r\nTrying to post data... \r\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }

    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf(" \r\nTrying to put resource... \r\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }

    //DELETE data
    //HTTPText inText(str, 512);
    printf(" \r\nTrying to delete resource... \r\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }

    printf("Demo completed. \r\n");
    wifi.disconnect();
}
