/*****************************************************************************
*
*  C++ interface/implementation created by Martin Kojtal (0xc0170). Thanks to
*  Jim Carver and Frank Vannieuwkerke for their inital cc3000 mbed port and
*  provided help.
*
*  This version of "host driver" uses CC3000 Host Driver Implementation. Thus
*  read the following copyright:
*
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/
#include "cc3000.h"

namespace mbed_cc3000 {
cc3000_server::cc3000_server(cc3000 &cc3000_ref, sockaddr socket_add) : _socket_address(socket_add), _cc3000(cc3000_ref) {
    _current_socket = -1;
}

cc3000_server::cc3000_server(cc3000 &cc3000_ref, sockaddr socket_add, int16_t socket) : _socket_address(socket_add), _cc3000(cc3000_ref) {
    _current_socket = socket;
}

int32_t cc3000_server::accept(void) {
    int32_t client_descriptor = -2;
    sockaddr dest_address;

    socklen_t address_length = sizeof(dest_address);
    _current_socket = 0;

    DBG_HCI("Waiting for receiving a connection");

    while((client_descriptor == -1) || (client_descriptor == -2))
    {
        client_descriptor = _cc3000._socket.accept(_current_socket,&dest_address, &address_length);
    }

    DBG_HCI("Received");

    _current_socket = client_descriptor;

    return _current_socket;
}

int32_t cc3000_server::receive(void *buffer, uint16_t length, uint32_t flags) {
    return _cc3000._socket.recv(_current_socket, buffer, length, flags);
}

int32_t cc3000_server::send(void *buffer, uint16_t length, uint32_t flags) {
    return _cc3000._socket.send(_current_socket, buffer, length, flags);
}

void cc3000_server::bind(void) {
    _cc3000._socket.bind(_current_socket, &_socket_address, sizeof(sockaddr));
}

void cc3000_server::listen(uint32_t backlog) {
    _cc3000._socket.listen(_current_socket, backlog);
}

void cc3000_server::close(void) {
    _cc3000._socket.closesocket(_current_socket);
}

}
