#include "mbed.h"

Timeout timer;
InterruptIn my_button(USER_BUTTON);
DigitalOut my_pwm(LED1); // IO used by pwm_io function

int on_delay = 0;
int off_delay = 0;
float duty[5]={0.2f,0.4f,0.6f,0.8f,1.0f};
int i=0;
void toggleOff(void);

void toggleOn(void) {
    my_pwm = 1;
    timer.attach_us(toggleOff, on_delay);
}

void toggleOff(void) {
    my_pwm = 0;
    timer.attach_us(toggleOn, off_delay);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        my_pwm = 0;
        return;
    }
    if (dc >= 1) {
        my_pwm = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn();
}
void pressed()
{   if(i>=5)
        i=0;

    pwm_io(20000,duty[i]);
    i++;
}

int main() {
    my_button.fall(&pressed);
    pwm_io(20000, 0.25); // 20ms - 25%
    
    while(1) {
        
    }
}
 