#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketServer.h"
#include "TCPSocketConnection.h"

#ifndef TCPLISTENER_H
#define TCPLISTENER_H
    /**
    * Class used to receive segments using TCP.
    */
    class TCPlistener{
        private:
            EthernetInterface eth;
            TCPSocketServer server;
        public:
            /**
            * Initialise with ip address of 192.168.0.253, a mask of 255.255.255.0 and a gateway of 192.168.0.254.
            * Starts a TCP server which will listen on port 4000.
            */
            TCPlistener();
            
            /**
            * Receives all packets sent to 192.168.0.253:4000.
            * @param contents The location where the segment contents will be written, formatted as null terminated character array.
            * @param size The max size of the "contents" array.
            * @return True if a segment was received, false if no segment was received.
            */
            bool receiveSegment(char *contents,int size);
    };
#endif