#ifndef LEDDRIVER_H 
#define LEDDRIVER_H 

#include "mbed.h"
#include "rtos.h"

class LEDDriver
{
    private:
    int mask;
    int messageList[8];
    uint32_t codedMessage0;
    uint32_t codedMessage1;
    uint32_t codedMessage2;
    uint32_t codedMessage3;
    uint32_t codedMessage4;
    Queue<int,8>* queue;
    DigitalOut *leds[8];
    int currentLocation;
    
    /**
     *methode om nieuwe richtingen van de receiver klasse te ontvangen
     *@params aantal leds die een nieuw bericht moeten krijgen  
     */ 
    void poll(int numberOfLeds);
   
    /**
    * Stel alle LEDS in voor een gegeven positie in het signaal. Voor juiste werking dien je de mask telkens te shiften. 
    *@param  De positie in het signaal viqa de  (kan gaan van 0 tot 24).
    */
    void setLEDS(int mask);
    
     public:
         
    /**
     *methode dat alle leds aanstuurt
     *@params aantal leds aan te sturen
     */    
    void drive(int numberOfLeds);
    
    /**
      *constructor voor een driver object
      *@params de queue met de waarden die een richting aanduiden
      */  
    LEDDriver(Queue<int,8>* queue);
    /*
     *Destructor 
     */
    ~LEDDriver();
    
    /**
    * Functie die 8 leds aanstuurt.
    */
    void drive8leds();
    
    /**
    * Stelt de Arraymembers in op hun default waarde.
    */
    void initArrays();
};        

#endif