#include "rtos.h"
#include "TCPlistener.h"

#ifndef INTERPRETER_H
#define INTERPRETER_H
    
    /**
    * Class used to interpret text commands.
    */
    class Interpreter{
        private:
            /**
            * Convert a direction such as left, right, up, down to the corresponding number (0, 1, 2 or 3).
            * Invalid directions (or ignore) will return 4.
            * @param command A character array representing the direction.
            */
            int directionToNumber(char* direction);
            Queue<int,8>* queue;
            int LED[8];
        public:
            
            /**
            * @param queue A pointer to the queue where the results will be written.
            */
            Interpreter(Queue<int,8>* queue);
            
            /**
            * Interprets a text command, and push the result on the queue.
            * Syntax:
            * The number of the LED
            * Dash (-)
            * The orientation (left,right,up,down or ignore).
            * Multiple LEDS can be set up in one command, by using a whitespace.
            * Example: 0-left 1-right 2-up
            * @param command A character array representing the command.
            */
            void executeCommand(char* command);
    };
#endif