#include "rtos.h"
#include "Interpreter.h"
#include "TCPlistener.h"

#ifndef RECEIVER_H
#define RECEIVER_H
    /**
    * A class used to receive commands via TCP and execute them.
    */
    class Receiver{
        private:
            Queue<int,8>* queue;
            Interpreter interpreter;
            TCPlistener listener;
            char command[512];
        public:
            /**
            *@param queue The queue where received and interpreted commands will we pushed.
            */
            Receiver(Queue<int,8>* queue);
            
            /**
            *Start a loop that will receive packets, and push their contents on the queue.
            *This method should be called last.
            */
            void start();
    };
#endif