#include "LEDDriver.h" 
Serial pc(USBTX,USBRX);
LEDDriver::LEDDriver( Queue<int,8>* queue)
{
    this->queue=queue;
    initArrays();
    currentLocation=0;
    mask=16777216;
    codedMessage0=0x1F54AAD;//32852653;// 2796202 commented message is frequency measure message(standard square wave) 4:('1')+2 ticker 0.002f. (250Hz, 10ms down)
    codedMessage1=0x1F54CAD;//32853165
    codedMessage2=0x1F552AD;//32854701;
    codedMessage3=0x1F554AD;//32855213;
    codedMessage4=0;  
}

void LEDDriver::drive(int numberOfLeds)
{
    if(currentLocation>=25){
        currentLocation=0;
        mask = 16777216;
    }
    if(currentLocation==0){
        poll(numberOfLeds);
    }
    setLEDS(mask);
    mask=mask>>1;
    currentLocation++;
    
}

void LEDDriver::drive8leds(){
    drive(8);
}

void LEDDriver::poll(int numberOfLeds)
{
        for(int i =0;i<(numberOfLeds);i++)
        { 
            osEvent event = queue->get();
            int temp = *((int*)event.value.p);
            if(temp==0||temp==1||temp==2||temp==3||temp==4)
            {
                messageList[i]=temp; 
            }     
        }            
}

void LEDDriver::initArrays()
{
    int tempMessageList[8]={4,4,4,4,4,4,4,4};
    DigitalOut *tempLeds[]={new DigitalOut(p11),new DigitalOut(p10),new DigitalOut(p12),new DigitalOut(p13),new DigitalOut(p14),new DigitalOut(p15),new DigitalOut(p16),new DigitalOut(p17)};
    
    memcpy(messageList,tempMessageList,sizeof(messageList));
    memcpy(leds,tempLeds,sizeof(leds));
}

void LEDDriver::setLEDS(int mask){
    for(int led =0 ; led<8;led++)
        {
            if(messageList[led]==0)
            {
               leds[led]->write(codedMessage0&mask);
            }
            else if(messageList[led]==1)
            {
               leds[led]->write(codedMessage1&mask);
            }
            else if(messageList[led]==2)
            {
                leds[led]->write((codedMessage2)&mask);
            }
            else if(messageList[led]==3)
            {
               leds[led]->write((codedMessage3)&mask);
            }
            else if(messageList[led]==4||messageList[led]==-1)
            {
             leds[led]->write((codedMessage4)&mask);
            }
        }
}

LEDDriver::~LEDDriver(){
    for(int i=0;i<8;i++){
        delete leds[i];    
    }
}