/*!
 *****************************************************************************
 *@file:  cn0353_init_params.h
 *
 *@brief: initial parameters file for EVAL-CN0535-FMCZ example program
 *
 *@details: initial parameters file for EVAL-CN0535-FMCZ example program
 *-----------------------------------------------------------------------------
 *
 Copyright (c) 2021 Analog Devices, Inc.
 All rights reserved.

 This software is proprietary to Analog Devices, Inc. and its licensors.
 By using this software you agree to the terms of the associated
 Analog Devices Software License Agreement.
 *****************************************************************************/

#ifndef _CN0353_INIT_PARAMS_H_
#define _CN0353_INIT_PARAMS_H_

#ifdef __cplusplus
extern "C"
{
#endif
#include <mbed.h>
#include <stdint.h>
#include "platform_drivers.h"
#include "platform_support.h"
#include "spi_extra.h"
#include "gpio.h"
#include "ad77681.h"


/******************************************************************************/
/********************** Macros and Constants Definitions **********************/
/******************************************************************************/


#define DRDY_PIN			D2
#define ADC_RST_PIN			D3
	
// Init params

// Init SPI extra parameters structure
mbed_spi_init_param spi_init_extra_params = {
	.spi_clk_pin =	SPI_SCK,
	.spi_miso_pin = SPI_MISO,
	.spi_mosi_pin = SPI_MOSI
};											 
// SPI bus init parameters
spi_init_param spi_params = {
	20000000,		// SPI Speed
	SPI_CS,			// SPI CS select index
	SPI_MODE_3,		// SPI Mode 
	&spi_init_extra_params, // SPI extra configurations
};

// Initial parameters for the ADC AD7768-1
ad77681_init_param init_params = { 
	
	spi_params,					// SPI parameters
	AD77681_ECO,				// power_mode
	AD77681_MCLK_DIV_16,		// mclk_div
	AD77681_CONV_CONTINUOUS,	// conv_mode
	AD77681_AIN_SHORT,			// diag_mux_sel
	false,						// conv_diag_sel
	AD77681_CONV_24BIT,			// conv_len
	AD77681_NO_CRC,				// crc_sel
	0,							// status bit
	AD77681_VCM_HALF_VCC,		// VCM setup
	AD77681_AINn_ENABLED,		// AIN- precharge buffer
	AD77681_AINp_ENABLED,		// AIN+ precharge buffer			
	AD77681_BUFn_ENABLED,		// REF- buffer
	AD77681_BUFp_ENABLED,		// REF+ buffer
	AD77681_FIR,				// FIR Filter
	AD77681_SINC5_FIR_DECx32,	// Decimate by 32
	0,							// OS ratio of SINC3
	4096,						// Reference voltage
	16384,						// MCLK in kHz
	32000,						// Sample rate in Hz
	1,							// Data frame bytes
};

// Inital params of a GPIO, to which the DRDY signal of the ADC is connected
gpio_desc gpio_drdy = { 
	DRDY_PIN, 				// GPIO pin
	NULL,
};

// Inital params of a GPIO, to which the RST signal of the ADC is connected
gpio_desc gpio_reset = { 
	ADC_RST_PIN,			// GPIO pin
	NULL,  
};	

/*
 *  User-defined coefficients for programmable FIR filter, max 56 coeffs
 *  
 *  Please note that, inserted coefficiets will be mirrored afterwards,
 *  so you must insert only one half of all the coefficients.
 *  
 *  Please note your original filer must have ODD count of coefficients,
 *  allowing internal ADC circuitry to mirror the coefficients properly.
 *  
 *	In case of usage lower count of coeffs than 56, please make sure, that
 *	the variable 'count_of_active_coeffs' bellow, carries the correct number
 *	of coeficients, allowing to fill the rest of the coeffs by zeroes
 *
 *	Default coeffs:
 **/
const uint8_t count_of_active_coeffs = 56;

const float programmable_FIR[56] = { 
		
  -0.000064967,
   0.000216258,
   0.000437060,
   0.000513474,
   0.000396842,
   0.000097234,
  -0.000304613,
  -0.000667916,
  -0.000831172,
  -0.000674257,
  -0.000182842,
   0.000514726,
   0.001164754,
   0.001468219,
   0.001203813,
   0.000347908,
  -0.000865494,
  -0.001987698,
  -0.002506034,
  -0.002058142,
  -0.000626378,
   0.001379936,
   0.003214906,
   0.004053861,
   0.003337280,
   0.001065705,
  -0.002092961,
  -0.004965216,
  -0.006281280,
  -0.005199392,
  -0.001740302,
   0.003068791,
   0.007451037,
   0.009496076,
   0.007936363,
   0.002786057,
  -0.004444805,
  -0.011117611,
  -0.014356987,
  -0.012188594,
  -0.004503385,
   0.006564770,
   0.017091120,
   0.022597229,
   0.019721226,
   0.007756722,
  -0.010529983,
  -0.029205128,
  -0.040639396,
  -0.037782094,
  -0.016555659,
   0.022417307,
   0.073383876,
   0.126572621,
   0.170602851,
   0.195514282,

};
	
#ifdef __cplusplus 
}				  
#endif // __cplusplus 	
#endif // !_CN0353_INIT_PARAMS_H_

