#include "LinearCharacteristics.h"

using namespace std;

LinearCharacteristics::LinearCharacteristics(float gain,float offset){    // standard lin characteristics
    this->gain = gain;
    this->offset = offset;
}

LinearCharacteristics::LinearCharacteristics(float minX, float maxX,float minY, float maxY){    // standard lin characteristics
    this->gain = (maxY-minY)/(maxX-minX);
    this->offset = maxX - (maxY/this->gain);
}

LinearCharacteristics::~LinearCharacteristics() {}


float LinearCharacteristics::evaluate(float x)
{   
return this->gain*(x - this->offset);
}
