/*Program Example 7.6: I2C Slave, when called transfers switch state to mbed acting as Master, and
displays state of Master’ s switches on its leds.
*/
#include <mbed.h>
I2CSlave slave(p28, p27); //Configure I2C slave
DigitalOut red_led(LED1); //red led
DigitalOut green_led(LED2); //green led
DigitalIn switch_ip1(p5);
DigitalIn switch_ip2(p6);
char switch_word ; //word we will send
char recd_val; //value received from master

int main() {
    slave.address(0x52);
        while (1) {
            //set up switch_word from switches that are pressed
            switch_word=0xa0; //set up a recognizable output pattern
            if (switch_ip1==1)
            switch_word=switch_word|0x01;
            if (switch_ip2==1)
            switch_word=switch_word|0x02;
            slave.write(switch_word); //load up word to send
            //test for I2C, and act accordingly
            int i = slave.receive();
            if (i == 3){ //slave is addressed, Master will write
            recd_val= slave.read();
            //now set leds according to received word
            red_led=0; //preset both to 0
            green_led=0;            
            recd_val=recd_val&0x03; //AND out unwanted bits
            if (recd_val==1)
                red_led=1;
            if (recd_val==2)
                green_led=1;
            if (recd_val==3){
                red_led=1;
                green_led=1;
            }
            }
        }
}