#include "mbed.h"
#include "DevSPI.h"
#include "XNucleoIHM02A1.h"

// after online publish

//   MBED PUBLISH -A //////////////////////////
//   MBED PUBLISH -A //////////////////////////
//   MBED PUBLISH -A //////////////////////////

#define Hovno 0
#define Hovnaa 10


#define MPR_1 4 /* Number of movements per revolution. */
#define STEPS_1 (400 * 128)   /* 1 revolution given a 400 steps motor configured at 1/128 microstep mode. */
#define STEPS_2 (STEPS_1 * 2)  /* 1 revolution given a 400 steps motor configured at 1/128 microstep mode. */
#define DELAY_1 1000     /* Delay in milliseconds. */
#define DELAY_2 2000    /* Delay in milliseconds. */
#define DELAY_3 5000    /* Delay in milliseconds. */



XNucleoIHM02A1 *x_nucleo_ihm02a1;  /* Motor Control Expansion Board. */

/* Initialization parameters of the motors connected to the expansion board. */
L6470_init_t init[L6470DAISYCHAINSIZE] = {
    /* First Motor. */
    {
        9.0,                           /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    },

    /* Second Motor. */
    {
        9.0,                           /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    }
};


/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
#ifdef TARGET_STM32F429
    DevSPI dev_spi(D11, D12, D13);
#else
    DevSPI dev_spi(D11, D12, D3);
#endif


    x_nucleo_ihm02a1 = new XNucleoIHM02A1(&init[0], &init[1], A4, A5, D4, A2, &dev_spi);      /* Initializing Motor Control Expansion Board. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();       /* Building a list of motor control components. */


    printf("Motor Control Application Example for 2 Motors\r\n\n");
    printf("--> Setting home position.\r\n");    /* Printing to the console. */
    motors[0]->set_home(); /* Setting the home position. */
    wait_ms(DELAY_1);

    int position = motors[0]->get_position();     /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);
    wait_ms(DELAY_1);

    printf("--> Moving forward %d steps.\r\n", STEPS_1);
    motors[0]->move(StepperMotor::FWD, STEPS_1);      /* Moving. */
    motors[0]->wait_while_active();  /* Waiting while active. */
    position = motors[0]->get_position();     /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);


    printf("--> Marking the current position.\r\n");
    motors[0]->set_mark();     /* Marking the current position. */
    wait_ms(DELAY_1);


    printf("--> Moving backward %d steps.\r\n", STEPS_2);
    motors[0]->move(StepperMotor::BWD, STEPS_2);   /* Moving. */
    motors[0]->wait_while_active(); /* Waiting while active. */
    wait_ms(DELAY_1);     /* Waiting. */
    position = motors[0]->get_position();  /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);
    wait_ms(DELAY_1);


    printf("--> Going to marked position.\r\n");  /* Printing to the console. */
    motors[0]->go_mark(); /* Going to marked position. */
    motors[0]->wait_while_active();  /* Waiting while active. */
    wait_ms(DELAY_1);   /* Waiting. */
    position = motors[0]->get_position();   /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);
    wait_ms(DELAY_1);


    printf("--> Going to home position.\r\n");
    motors[0]->go_home();  /* Going to home position. */
    motors[0]->wait_while_active(); /* Waiting while active. */
    wait_ms(DELAY_1);
    position = motors[0]->get_position(); /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);  /* Printing to the console. */
    wait_ms(DELAY_1);  /* Waiting. */

    printf("--> Halving the microsteps.\r\n");

    init[0].step_sel = (init[0].step_sel > 0 ? init[0].step_sel -  1 : init[0].step_sel); /* Halving the microsteps. */
    if (!motors[0]->set_step_mode((StepperMotor::step_mode_t) init[0].step_sel))
        {
            printf("    Step Mode not allowed.\r\n");
        }
    wait_ms(DELAY_1);
    

    printf("--> Setting home position.\r\n");
    motors[0]->set_home();  /* Setting the home position. */
    wait_ms(DELAY_1);
    position = motors[0]->get_position();    /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);
    wait_ms(DELAY_1);


    printf("--> Moving forward %d steps.\r\n", STEPS_1);
    motors[0]->move(StepperMotor::FWD, STEPS_1); /* Moving. */
    motors[0]->wait_while_active();    /* Waiting while active. */
    position = motors[0]->get_position();   /* Getting the current position. */
    printf("--> Getting the current position: %d\r\n", position);


    printf("--> Marking the current position.\r\n");
    motors[0]->set_mark();    /* Marking the current position. */
    wait_ms(DELAY_2);


    /*----- Running together for a certain amount of time. -----*/
    printf("--> Running together for %d seconds.\r\n", DELAY_3 / 1000);
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)     /* Preparing each motor to perform a run at a specified speed. */
        {
            motors[m]->prepare_run(StepperMotor::BWD, 400);
        }
    x_nucleo_ihm02a1->perform_prepared_actions();   /* Performing the action on each motor at the same time. */
    wait_ms(DELAY_3);


    /*----- Increasing the speed while running. -----*/
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)       /* Preparing each motor to perform a run at a specified speed. */
        {
            motors[m]->prepare_get_speed();
        }
    uint32_t* results = x_nucleo_ihm02a1->perform_prepared_actions();      /* Performing the action on each motor at the same time. */
    printf("    Speed: M1 %d, M2 %d.\r\n", results[0], results[1]);
    printf("--> Doublig the speed while running again for %d seconds.\r\n", DELAY_3 / 1000);
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++) /* Preparing each motor to perform a run at a specified speed. */
        {
            motors[m]->prepare_run(StepperMotor::BWD, results[m] << 1);
        }


    results = x_nucleo_ihm02a1->perform_prepared_actions();      /* Performing the action on each motor at the same time. */
    wait_ms(DELAY_3);



    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)      /* Preparing each motor to perform a run at a specified speed. */
        {
            motors[m]->prepare_get_speed();
        }
    results = x_nucleo_ihm02a1->perform_prepared_actions();      /* Performing the action on each motor at the same time. */
    printf("    Speed: M1 %d, M2 %d.\r\n", results[0], results[1]);
    wait_ms(DELAY_1);


    /*----- Hard Stop. -----*/
    printf("--> Hard Stop.\r\n");


    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)     /* Preparing each motor to perform a hard stop. */
        {
            motors[m]->prepare_hard_stop();
        }
    x_nucleo_ihm02a1->perform_prepared_actions();        /* Performing the action on each motor at the same time. */
    wait_ms(DELAY_2);


    /*----- Doing a full revolution on each motor, one after the other. -----*/
    printf("--> Doing a full revolution on each motor, one after the other.\r\n");


    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)      /* Doing a full revolution on each motor, one after the other. */
        {
            for (int i = 0; i < MPR_1; i++)
                {
                    int steps = (int) (((int) init[m].fullstepsperrevolution * pow(2.0f, init[m].step_sel)) / MPR_1);             /* Computing the number of steps. */
                    motors[m]->move(StepperMotor::FWD, steps);/* Moving. */
                    motors[m]->wait_while_active();  /* Waiting while active. */
                    wait_ms(DELAY_1);
                }
        }
    wait_ms(DELAY_2);


    /*----- High Impedance State. -----*/

    printf("--> High Impedance State.\r\n");


    for (int m = 0; m < L6470DAISYCHAINSIZE; m++)       /* Preparing each motor to set High Impedance State. */
        {
            motors[m]->prepare_hard_hiz();
        }
    x_nucleo_ihm02a1->perform_prepared_actions();         /* Performing the action on each motor at the same time. */
    wait_ms(DELAY_2);
}
