#include "mbed.h"
#include "ShiftReg.h"
 #include <iostream>
 #include <string>
 
 using namespace std;
 

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

Ticker seg; //7segment timeloop

int cycle;  //7segment timeloop global variable
int segment [] = {0b00000011,0b10011111,0b00100101,0b00001101,0b10011001,0b01001001,0b01000001,0b00011111,0b00000001,0b00011001,0b11111111};   //7segment coding

ShiftReg   HC595(PA_9, PB_5, PA_8);   //shiftreger pinout
int poz4;  //char for etch 7 segment
int poz3;
int poz2;
int poz1;
int value = 0;
char u;
string sentence;

PwmOut buzzer(PA_5);

void transformer ()    // int to 4x7
{
    poz4 = value / 1000;
    poz3 = (value - (poz4 * 1000))/100;
    poz2 = (value - (poz4 * 1000) - (poz3 * 100))/10;
    poz1 = (value - (poz4 * 1000) - (poz3 * 100) - (poz2 * 10))%10;
}

void interr()          //Shift register update for each 7segment
{
    transformer();   //update
    cycle++;
    if (cycle == 1) {
        HC595.ShiftByte(segment[poz4], ShiftReg::LSBFirst);     //segment   (Prvy v poradi)
        HC595.ShiftByte(0b00000001, ShiftReg::MSBFirst);    //Pozicia  (druhy v poradi)
        HC595.Latch();
    }
    if (cycle == 2) {
        HC595.ShiftByte(segment[poz3] - 1, ShiftReg::LSBFirst);     //segment   (Prvy v poradi)
        HC595.ShiftByte(0b00000010, ShiftReg::MSBFirst);    //Pozicia  (druhy v poradi)
        HC595.Latch();
    }
    if (cycle == 3) {
        HC595.ShiftByte(segment[poz2], ShiftReg::LSBFirst);     //segment   (Prvy v poradi)
        HC595.ShiftByte(0b00000100, ShiftReg::MSBFirst);    //Pozicia  (druhy v poradi)
        HC595.Latch();
    }
    if (cycle == 4 ) {
        HC595.ShiftByte(segment[poz1], ShiftReg::LSBFirst);     //segment   (Prvy v poradi)
        HC595.ShiftByte(0b00001000, ShiftReg::MSBFirst);    //Pozicia  (druhy v poradi)
        HC595.Latch();
    }
    if (cycle == 5 ) {
        cycle = 0;
        HC595.ShiftByte(0x00, ShiftReg::MSBFirst);
        HC595.Latch();
    }
}




int main()
{

    buzzer.period_ms(100);
    buzzer.pulsewidth_ms(99);
    seg.attach_us(&interr, 2000); //
    value = 0;
    cout << "OK this looks this is firs lin in C++ code :)" << endl;
    cin >> sentence ;
    cout << sentence << endl;
    while(1) {
        //cin >> sentence;
        char a = cin.get();
        cin >> sentence;
        if (a == 13) {
        cout << sentence;
        pc.printf("\n"); }
        else if (a == 32){
        cout << sentence ;
        pc.printf(" "); }
        else {
        cout << sentence; }
        buzzer.write(0.5);
        wait(0.2);
        buzzer.write(0);
       
    }//end of while (1)

}//end off main



