#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"

PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

C12832_LCD lcd;
LM75B tmp(p28,p27);

BusIn joy(p12,p13,p15,p16);
DigitalIn fire(p14);

BusOut leds(LED1,LED2,LED3,LED4);
AnalogIn p(p19);
AnalogIn p2(p20);
PwmOut spkr(p26);

int main ()

{

    while (1) {
    int a=p*80;
    
    lcd.cls();

    lcd.locate(0,3);//location of Temp. information sentence

    lcd.printf("Room Temp. :%.2foC",tmp.read()); //Temp. information
    
    lcd.locate(a,15); //location of LEDs state sentence
    
    if (fire){//LEDs state
    
    lcd.printf("ALL LED ON");
    }
    else if(leds == 0x1) { 
    lcd.printf("LED1 ON");
    }
    else if(leds == 0x2) { 
    lcd.printf("LED2 ON");
    }
    else if(leds == 0x4) { 
    lcd.printf("LED3 ON");
    }
    else if(leds == 0x8) { 
    lcd.printf("LED4 ON");
    }
        wait(0.1);
        if (fire) {
         leds=0xf;
           for (float i=2000.0; i<10000.0; i+=100) {//speaker enable if all LEDs on
            spkr.period(1.0/i);
            spkr=p2;
            wait(0.1);
        }                    
            
        } else {
            leds=joy;
            spkr = 0;
        }
       
        wait(0.1);
   
       
        for(float i = 0.0; i < 1.0 ; i += 0.01) {
            float p = (((tmp.read()/100)-0.298)*60);//rgb LED colour calculation
            b = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            r = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ; 
            wait (0.01);

        }
    
    }


}
