#include "mbed.h"

#define TIME        0.001     //en segundos, cada cuanto se hace la interrupcion (1ms)
#define ENCENDIDO   1
#define APAGADO     0
#define APRETADO    1
#define NO_APRETADO 0

typedef unsigned char BYTE;

enum{ESTADO_BAJO, ESTADO_ALTO};

/* -----clases----- */
PwmOut CLOCK(PTC8);
PwmOut DATA(PTA5);
DigitalOut OUT(PTA4);
Serial pc(USBTX, USBRX);

/* -----prototipos funciones----- */
void init_mcu(void);
BYTE COD_Step();

/* -----variables globales----- */
BYTE COD_estado;
    
int main() {
    init_mcu();
    CLOCK.period_ms(10);
    CLOCK.pulsewidth_ms(5);
    pc.printf("CLOCK: pwm set to %.2f %%\n", CLOCK.read() * 100);
    DATA.period_ms(10);
    DATA.pulsewidth_ms(8);
    pc.printf("DATA: pwm set to %.2f %%\n", DATA.read() * 100);
    while(1) {
        pc.printf("SALIDA: %d\n", COD_Step());
    }
}

BYTE COD_Step(){
    switch(COD_estado){
        default:
        case ESTADO_BAJO:
            OUT = APAGADO;
            if(DATA == CLOCK){
                COD_estado = ESTADO_ALTO;
            }
            break;  
        case ESTADO_ALTO:
            OUT = ENCENDIDO;
            if(DATA != CLOCK){
                COD_estado = ESTADO_BAJO;
            }
            break;
    }
    return COD_estado;
}

void init_mcu(void){
    COD_estado = ESTADO_BAJO;
    pc.printf("PROGRAMA INICIALIZADO\n");
} 