#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"

Serial mon_module_bluetooth(D14,D15);
Grove_LCD_RGB_Backlight lcd(D7,D6); //CDA SCL
DigitalIn FdcIni(D2);

int main()
{
    printf("Coucou\r\n");
    int etat = 0;
    int N_precedent = 0;
    int N = FdcIni.read();
    bool waitIni = false;
    int Moteur = 0;
    lcd.setRGB(100,255,255);
    while(1) {
        N_precedent = N;
        N = FdcIni.read();

        if (etat == 0) {
            char tab[15];
            lcd.locate(0,0);
            sprintf(tab, "Attente") ; //contenu de tab + val sous le format
            lcd.print(tab) ;
        }

        if (waitIni && N_precedent == 1 && N == 0) {
            waitIni = false;
            mon_module_bluetooth.printf("i");
            char tab[15];
            lcd.locate(0,0);
            lcd.clear();
            sprintf(tab, "Pret") ; //contenu de tab + val sous le format
            lcd.print(tab) ;
            etat = 2;
        }

        if (mon_module_bluetooth.readable()) {
            char le_caractere_lu=mon_module_bluetooth.getc();
            printf("%c\r\n",  le_caractere_lu);
            // mon_module_bluetooth.printf("2",le_caractere_lu);

            switch (etat) {
                case 0:
                    if(le_caractere_lu == 'a') { // Connected
                        mon_module_bluetooth.printf("a");
                        etat = 1;
                    }
                    break;
                case 1:
                    if(le_caractere_lu == 'i') { // Connected
                        waitIni = true;
                        char tab[15];
                        lcd.locate(0,0);
                        sprintf(tab, "Initialisation...") ; //contenu de tab + val sous le format
                        lcd.print(tab) ;
                    }
                    break;
                case 2:
                    if (le_caractere_lu == 'l') { // Gauche
                        Moteur = 1;
                    }
                    if (le_caractere_lu == 'r') { //Droite
                        Moteur = 2;
                    }
                    if (le_caractere_lu == 'n') { // On arrête
                        Moteur = 0;
                    }
                    break;
            }

            switch (etat) {
                case 0:

                    break;

                case 1:

                    break;

                case 2:
                    if (Moteur == 0) { // Arrêt
                        char tab[15];
                        lcd.locate(0,0);
                        lcd.clear();
                        sprintf(tab, "Pret") ; //contenu de tab + val sous le format
                        lcd.print(tab) ;
                    } else if (Moteur == 1) { // Gauche
                        char tab[15];
                        lcd.locate(0,0);
                        lcd.clear();
                        sprintf(tab, "Gauche") ; //contenu de tab + val sous le format
                        lcd.print(tab) ;
                    } else { // Droite
                        char tab[15];
                        lcd.locate(0,0);
                        lcd.clear();
                        sprintf(tab, "Droite") ; //contenu de tab + val sous le format
                        lcd.print(tab) ;
                    }
                    break;
            }
        }
    }
}
