/*
    main.cpp - Main file test modbus
    Copyright (C) 2019 Khiem Tran
*/
#include <mbed.h>
#include "ModbusSerial.h"
#include "mbed_mem_trace.h"
#include "mbed_stats.h"

Serial mbPort(PA_9, PA_10, 19200);
//Serial pc(PC_6, PC_7, 9600);
ModbusSerial mb;
PwmOut LD0(PA_6);

int main() {
  LD0.period(1);
  LD0.write(0.5);
  // Config Modbus Serial (port, speed, byte format)
  SerialFormat format;
  format.bits = 8;
  format.parity = SerialBase::None;
  format.stop_bits = 1;

  //Config Modbus
  mb.config(&mbPort, 19200, format);
  // Set the Slave ID (1-247)
  mb.setSlaveId(1);

  //Add Holding Reg
  mb.addHreg(0, 0);
  mb.addHreg(1, 0);
  mb.addHreg(2, 0);
  //   pc.printf("PC!\n");

  uint16_t test = 0;
  mbed_mem_trace_enable();    //Tracking memory usage for program. 

  while (1)
  {
    mb.Hreg(0, test);
    test++;
    mbed_stats_heap_t heap_stats;
    mbed_stats_heap_get(&heap_stats);
    mb.Hreg(1, heap_stats.current_size);    //Current ram usage.
    mb.Hreg(2, heap_stats.max_size);        //Max ram current.
    wait_ms(100);
  }
}