#include "mbed.h"
#include "mbed_stats.h"
#include "mbed_mem_trace.h"

int main(void)
{
    mbed_mem_trace_enable();    //Tracking memory usage for program.

    while (1) {

        mbed_stats_heap_t heap_stats;

        printf("Starting heap stats example\r\n");

        void *allocation = malloc(1000);
        printf("Freeing 1000 bytes\r\n");

        mbed_stats_heap_get(&heap_stats);
        printf("Current heap: %lu\r\n", heap_stats.current_size);
        printf("Max heap size: %lu\r\n", heap_stats.max_size);

        free(allocation);

        mbed_stats_heap_get(&heap_stats);
        printf("Current heap after: %lu\r\n", heap_stats.current_size);
        printf("Max heap size after: %lu\r\n", heap_stats.max_size);
        wait_ms(1000);
    }
}