#include "mbed.h"
#include "rtos.h"
#include "Serial.h"
#include "BufferedSerial.h"
#include "Communication.h"
#include "Motor.h"
#include <stdlib.h>
#include <stdio.h>
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "Capture.h"

DigitalIn myStopButton(USER_BUTTON);
Motor lid_Motor(PWM_OUT);
Communication SendCommands;
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
LCD_DISCO_F746NG lcd_Thread;


TS_StateTypeDef TS_State;

uint16_t x,y;
uint8_t idx;
uint8_t start=1;


void Fond(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)Capture.data;
    while(y < Capture.height) {
        while(x < Capture.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

void StopLidar_thread(void const *args) {                 
    wait(1);
    while(true) {
         if (myStopButton==1) {
                SendCommands.Stop();
                wait_ms(10);
                lid_Motor.StopMotor_Scan();
                wait_ms(10);
                SendCommands.Reset();
                wait_ms(10);
                lcd_Thread.DisplayOff();
        }
     }
}


int main() {
    
    Thread StopLidar__th(StopLidar_thread);           // THREAD 
    
   /*    PREMIERE INTERFACE
   
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    wait(0.3);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"LIDAR ", CENTER_MODE);
    lcd.SetFont(&Font8);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"K.ZAILLEL", RIGHT_MODE);


    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(136, 200, 200, 50);  

    lcd.SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(202, LINE(9), (uint8_t *)"SCAN", LEFT_MODE);*/
 
  while(start) {
      Fond(0,0);
      ts.GetState(&TS_State);                                  
      if (TS_State.touchDetected) {                                           
          for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
          }

     if((x>=136) && (x<=336) && (y>=200) && (y<=250)) {               // Bouton SCAN  
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    wait(0.3);
    lcd.SetFont(&Font16);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Scanning ... ", CENTER_MODE);     
                
          
   
//   Init UART
     SendCommands.confUART();

  // RESET
//   SendCommands.Reset();

  // Get_Health command
//   SendCommands.Get_Health();

  //  Get_Info command
//   SendCommands.Get_Info();

  // Start motor 
     lid_Motor.StartMotor_Scan();
     
//   Scan
     SendCommands.Scan();
     start=0;
        }
    }
 }
   
}


