# Getting started with Hello MQTT-SN

This guide reviews the steps required to use the MQTT-SN example on an mbed OS platform.

Please install [mbed CLI](https://github.com/ARMmbed/mbed-cli#installing-mbed-cli).

## Import the example application

From the command-line, import the example:

```
mbed import sara-n200-hello-mqtt-sn
cd sara-n200-hello-mqtt-sn
```

### Configure the MQTT-SN broker
Edit the mbed_app.json:
```
        "topic": "\"nucleo\"",
        "mqtt_sn_host": "\"160.119.253.14\"",
        "mqtt_sn_port": "10000"
```
Set the host (do not forget the escaped Quotation marks), port and topic to which your node will connect to

### Now compile

Invoke `mbed compile`, and specify the name of your platform and your favorite toolchain (`GCC_ARM`, `ARM`, `IAR`). For example, for the ARM Compiler 5:

```
mbed compile -m NUCLEO_F411RE -t GCC_ARM
```

Your PC may take a few minutes to compile your code. At the end, you see the following result:

```
[snip]
+-----------------------------------------+-------+-------+------+
| Module                                  | .text | .data | .bss |
+-----------------------------------------+-------+-------+------+
| MQTTSNPacket/MQTTSNConnectClient.o      |   274 |     0 |    0 |
| MQTTSNPacket/MQTTSNDeserializePublish.o |   390 |     0 |    0 |
| MQTTSNPacket/MQTTSNPacket.o             |   280 |     0 |    0 |
| MQTTSNPacket/MQTTSNSerializePublish.o   |   460 |     0 |    0 |
| MQTTSNPacket/MQTTSNSubscribeClient.o    |   304 |     0 |    0 |
| X-NUCLEO-SARA-N200/sara-n2.o            |  2018 |     0 |    0 |
| [fill]                                  |   172 |     4 |   18 |
| [lib]/c.a                               | 42290 |  2472 |   89 |
| [lib]/gcc.a                             |  3392 |     0 |    0 |
| [lib]/misc                              |   252 |    16 |   28 |
| main.o                                  |  3531 |    52 | 2099 |
| mbed-os/drivers                         |  3774 |     4 |  100 |
| mbed-os/features                        |    16 |     0 |    0 |
| mbed-os/hal                             |  1697 |     4 |   68 |
| mbed-os/platform                        |  6218 |   260 |  345 |
| mbed-os/rtos                            |  9058 |   168 | 6081 |
| mbed-os/targets                         |  8114 |     4 |  900 |
| Subtotals                               | 82240 |  2984 | 9728 |
+-----------------------------------------+-------+-------+------+
Total Static RAM memory (data + bss): 12712 bytes
Total Flash memory (text + data): 85224 bytes

Image: ./BUILD/NUCLEO_F411RE/GCC_ARM/sara-n200-hello-mqtt-sn.bin

```

### Program your board

1. Connect your mbed device to the computer over USB.
1. Copy the binary file to the mbed device.
1. Press the reset button to start the program.

The LED on your platform turns on and off.
Open a terminal to see debug information.

## Troubleshooting

If you have problems, you can review the [documentation](https://os.mbed.com/docs/latest/tutorials/debugging.html) for suggestions on what could be wrong and how to fix it.
