#if !defined(MQTTSOCKET_H)
#define MQTTSOCKET_H

#include "MQTTmbed.h"
#include "udp_interface.h"

class MQTTSNUDP
{
	int mSocket;
	UDPinterface *mInterface;
	char mHost[128];
	int mPort;

public:

	MQTTSNUDP(UDPinterface *interface) : mSocket(-1), mInterface(interface), mPort(-1)
	{
	}

    int connect(char* hostname, int port, int timeout=1000)
    {
        strncpy(mHost, hostname, 128);
        mPort = port;
        mSocket = mInterface->connect(hostname, port);
        return mSocket;
    }

    int read(unsigned char* buffer, int len, int timeout)
    {
    	char rxHost[256];
    	int rxPort;
        return mInterface->read(mSocket, rxHost, &rxPort, buffer, len, timeout);
    }
    
    int write(unsigned char* buffer, int len, int timeout)
    {
        return mInterface->write(mSocket, mHost, mPort, buffer, len, timeout);
    }
    
    int disconnect()
    {
    	return mInterface->disconnect(mSocket);
    }
};



#endif
