/*
 * sara_n2.h
 *
 *  Created on: 08 Aug 2018
 *      Author: Janus Erasmus
 */

#ifndef SRC_SARA_N2_H_
#define SRC_SARA_N2_H_

#include "mbed.h"
#include "MQTTSNUDP.h"
#include "udp_interface.h"

class SARA_N2 : public UDPinterface
{
public:
    enum eModemState
    {
        MODEM_UNKNOWN,
        MODEM_NEED_SIM,
        MODEM_SIM_PIN,
        MODEM_SIGNAL,
        MODEM_REGISTERED,
        MODEM_ATTACHING,
        MODEM_CONNECTED
    };

private:

    int mBufferFlag;
    ATCmdParser mCMD;
    DigitalOut *mReset;
    eModemState mState;
    char mSIMserial[32];
    char mIMEA[32];
    int mElapsed;
    Timer mTimer;

public:
    SARA_N2(FileHandle *fh, DigitalOut *reset_pin);
    virtual ~SARA_N2();

    void fsm();

    int connect(char *hostname, int port);
    bool disconnect(int id);

    static void receiveData(SARA_N2 *_this);
    char *getSIMserial(){ return mSIMserial; }
    char *getIMEA(){ return mIMEA; }

    int read(int sock_id, char *host, int *port, uint8_t *buff, int len, int timeout);
    int write(int sock_id, char *host, int port, uint8_t *buff, int len, int timeout);
};

#endif /* SRC_SARA_N2_H_ */
