/* This is just a demo by Kevin Lee */
#include "mbed.h"
#include "SDFileSystem.h"
#include "BLE.h"
#include "WIZnetInterface.h"
#include "HTTPClient.h"
#include "DHT.h"


#define USE_DHCP 0
#define LOOPBACKPORT  5000
int W5500_Test(void);

float temperature_get();         /* Grove - Temperature Sensor V1.2 */

SPI spi(SPI_PSELMOSI0, SPI_PSELMISO0, SPI_PSELSCK0);
WIZnetInterface ethernet(&spi, p24, p17); // Spi ,cs, reset
int ret, dummy, lv = 1;
const char * IP_Addr      = "192.168.21.247";
const char * IP_Subnet    = "255.255.255.0";
const char * IP_Gateway   = "192.168.21.2";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x1C,0xAA,0xCA};
 

DigitalOut myled(LED1);
//Arch Link
Serial pc(USBTX, USBRX);  /* uart */


DHT dht22(A1,DHT22);

AnalogIn   ain(A0);

int main() {
    char buffer[256];
    wait(1);
    pc.baud(115200);
    wait(1);
    printf("helloworld\r\n");  
    
    if(W5500_Test() == 0) {                  // Internet is ok
        printf("W5500 tested OK \r\n");
        
        char str[512];
        char get_msg[128]= "";
    
    /*
        http://dweet.io/follow/ArchLink
    */
        char nameYouWant[] = "ArchLink";
        while(1)
        {
            sprintf(get_msg,"http://dweet.io/dweet/for/%s?Temperature=%.2f",nameYouWant,temperature_get());
            printf("temperature_get: %.2f",temperature_get());
            HTTPClient http;
        
            pc.printf("Send post message to dweet.io\r\n");
            pc.printf("msg : %s\r\n",get_msg);
            ret = http.get(get_msg, str, sizeof(str));
            if(!ret)
            {
            pc.printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
            pc.printf("Result: %s\r\n", str);
            }
            else
            {
            pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
            wait(10);
       }
    }
    
    while(1) {
        myled = 1;
        printf("light1\r\n");
        wait(3);
        myled = 0;
        printf("light0\r\n");
        wait(3);
    }
}

int W5500_Test(void)
{
    mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    wait(1);
    printf("Start to test ethernet!\r\n");
    
    #if USE_DHCP
    printf("use DHCP\r\n");
    ret = ethernet.init(MAC_Addr);
    #else
    printf("do NOT use DHCP\r\n");
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    
    if (!ret) {
        pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            return 0;
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            //exit(0);
            return -1;
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        //exit(0);
        return -1;
    }
}


float temperature_get()
{
    /*
    float resistance = (float)(1023.0-val)*10000.0/(float)val;
    float temp = 1/(log(resistance/10000)/B+1/298.15)-273.15;
    */ 
    int B = 3975;
    float val = (ain.read()*1023);
    float resistance = (float)(1023.0-val)*10000.0/(float)val;
    float temp = 1/(log(resistance/10000)/B+1/298.15)-273.15;
    return temp;
}

