/*    
 * ShieldBot_v12.h
 * A library for ShieldBot
 *   
 * Copyright (c) 2015 seeed technology inc.  
 * Author      : Jiankai.li
 * Create Time:  Sep  2015
 * Change Log : 
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


// ensure this library description is only included once

#ifndef __SHIELDBOT_V12_H__
#define __SHIELDBOT_V12_H__

#include <stdint.h>


/** Color pixels class using WS2812B and nRF51822 (16Hz)
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "color_pixels.h"
 *
 * ColorPixels pixels(1, 32);
 *
 * int main() {
 *    pixels.set_color(0, 0, 255, 0);
 *    pixels.update();
 *
 *    while(1) {
 *    }
 * }
 * @endcode
 */
 
// library interface description
class Shieldbot
{
  // user-accessible "public" interface
  public:
    Shieldbot();
    int readS1();
    int readS2();
    int readS3();
    int readS4();
    int readS5();
    void setMaxSpeed(int);
    void setMaxSpeed(int, int);
    void setMaxLeftSpeed(int);
    void setMaxRightSpeed(int);
    void rightMotor(signed char);
    void leftMotor(signed char);
    void drive(signed char, signed char);
    void forward();
    void backward();
    void stop();
    void stopRight();
    void stopLeft();
    void fastStopLeft();
    void fastStopRight();
    void fastStop();

};

#endif
