/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 * This is gesture keyboard demo by Kevin Lee
 */

#include "mbed.h"
#include "Gesture.h"
#include "USBKeyboard.h"

// #ifdef DEBUG
// #include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
// #define LOG(args...)    pc.printf(args)
//#include "USBSerial.h"

//USBSerial pc;
//Serial  pc(USBTX, USBRX);
USBKeyboard keyboard;
I2C i2c(P0_5, P0_4);
Ticker  ticker;

#define dly 100             //LED delay

void Gesture_LED(PIXART_GESTURE_TYPE gesture);

void GetGestute(PIXART_GESTURE_TYPE gesture)
{
    //UP,DOWN,LEFT,RIGHT,PUSH,POLL,CLOCKWISE,COUNTER_CLOCKWISE,WAVE};
    switch (gesture)
    {
        case UP:
          // pc.printf("UP \r\n");
            keyboard.mediaControl(KEY_VOLUME_UP);
          break;
        case DOWN:
          // pc.printf("DOWN \r\n");
            keyboard.mediaControl(KEY_VOLUME_DOWN);
          break;
        case LEFT:
            keyboard.mediaControl(KEY_PREVIOUS_TRACK);
          // pc.printf("LEFT \r\n");
          break;
        case RIGHT:
            keyboard.mediaControl(KEY_NEXT_TRACK);
          // pc.printf("RIGHT \r\n");
          break;
        case PUSH:
            keyboard.mediaControl(KEY_MUTE);
          // pc.printf("PUSH \r\n");
          
          break;
        case POLL:
            keyboard.mediaControl(KEY_MUTE);
          break;
        case CLOCKWISE:
            keyboard.mediaControl(KEY_PLAY_PAUSE);
          // pc.printf("CLOCKWISE \r\n");
          break;
        case COUNTER_CLOCKWISE:
            keyboard.mediaControl(KEY_STOP);
          // pc.printf("COUNTER_CLOCKWISE \r\n");
          break;
        case WAVE:
          // pc.printf("WAVE \r\n");
          break;        
        default:
          // pc.printf("Nothing happen \r\n");          
    }  
    //Gesture_LED(gesture);
}

int main(void)
{  
//    pc.baud (115200);    
//    pc.printf("Start Pixart Gesture demo\n\r");
    
    i2c.frequency(400000);    
    
    
    bool Result = false;
    Pixart_Gesture *m_Gesture = new Pixart_Gesture(&i2c,100,GetGestute,Result);
    
//    if(Result == true)
//    {
//        pc.printf("Initial Pixart Gesture successful\n\r");
//    }
//    else
//    {
//        pc.printf("Initial Pixart Gesture fail\n\r");    
//    }
//        
        
    while(true)
        ;
}






