/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds

Name: Kern Fowler
Username: el17kjtf
Student ID Number: 201116686
Date: 08/05/2019
Version: 1.4

*/

// Includes all required classes in their respective libraries.
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Donkey.h"
#include "Options.h"
#include "Controls.h"
#include "Instructions.h"
#include "HighScores.h"
#include "Banana.h"
#include "Barrel.h" 
#include "GameEngine.h"

// Define all objects.
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); // LCD class object- pins format required only in define. 
Gamepad pad; // Gamepad class obejct.
Donkey dky; // Donkey Kong class object.
Barrel barrel; // Barrel class object.
Banana banana; // Banana class object.
GameEngine eng; // GameEngine class object.
Options opt; // Options Menu class object.
Controls cont; // Controls Menu class object.
Instructions instr; // Instructions Menu class object.
HighScores high; // HighScores Menu class object.
Serial pc(USBTX, USBRX); // Used for testing.

// Prototypes
void init(); // 
void print_menu();
void welcome();
void arrow_location();
void arrow_select();

// Intialise Menu Variables
int fps = 24;
int direction;
int menu_option_pos = 0;
int arrow_pos = 0;

int menu_arrow[7][7] = { // Arrow pointer sprite used in main menu.
{0,0,0,0,0,0,0,},
{0,0,0,0,1,0,0,},
{0,0,0,0,1,1,0,},
{1,1,1,1,1,1,1,},
{0,0,0,0,1,1,0,},
{0,0,0,0,1,0,0,},
{0,0,0,0,0,0,0,},
};

int menu_dk_face[36][34] =   { // Donkey Kong face sprite used in opening scene.
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0 },
    { 0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0 },
    { 0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
    { 0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,1,0 },
    { 0,1,0,0,0,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,1,0 },
    { 0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,1,0 },
    { 0,1,0,1,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,1,0 },
    { 0,1,0,1,0,1,0,0,1,0,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0 },
    { 0,1,0,1,1,1,1,0,1,0,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,0,1,1,1,1,0,1,0 },
    { 0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0 },
    { 0,0,1,0,0,1,1,1,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,0,0,1,0,0 },
    { 0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0 },
    { 0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,1,0 },
    { 0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0 },
    { 0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    };

// Functions
int main() {
    init();  // Initialises the LCD and Gamepad.
    welcome();  // Displays welcome screen, has information about the creator and title screen.
    while(1) {  // Main menu loop
    arrow_location(); // Determines arrow position on screen, will go up and down with joystick commands.
    print_menu();  // This re-prints the menu at the start of every loop.
    arrow_select(); // Will select the current menu options when A button pressed.
    wait_ms(1.0f/fps);
    }
}

// Initialises Gamepad and LCD.
void init() {
    lcd.init();
    pad.init();
    wait(2.5);
}

// Moves arrow sprite up or down depending on joystick commands. If reaches the bottom will go back to top position.
void arrow_location() {
    direction  = pad.get_direction();
    if (direction == N) { // Will occur if the joystick is pushed up.
        menu_option_pos = menu_option_pos - 1;
        // printf("North Pressed");
        wait_ms(250);
    }
    if (direction == S) { // Will occur if the joystick is pushed down.
        menu_option_pos = menu_option_pos + 1;
        // printf("South Pressed");
        wait_ms(250);
    }
    if (menu_option_pos > 4) {
        menu_option_pos = 0;
    }
    if (menu_option_pos < 0) {
        menu_option_pos = 4;
    }
    arrow_pos = 8 + (menu_option_pos * 8); // Sets and offset due to sprite and font size.
    // printf("Option Num = %d", menu_option_pos)
}

// Runs the current menu option the arrow has selected when A is pressed.
void arrow_select() {
    if (pad.check_event(Gamepad::A_PRESSED) == true) {
        if (menu_option_pos == 0) { // Start Game option.
            // printf("GameEngine");
            eng.gameengine_run(pad, lcd, barrel, banana, dky, opt); // Runs the main game loop in the GameEngine class.
            eng.gameengine_score(pad, lcd, banana, high); // When gameover is reached, runs the end game screen.
        }
        if (menu_option_pos == 1) { // Controls option.
            // printf("Controls");
            cont.controls_run(pad, lcd); // Runs the controls screen loop.
        }
        if (menu_option_pos == 2) { // Instructions option.
            // printf("Instructions");
            instr.instructions_run(pad, lcd); // Runs the instructions screen loop.
        }
        if (menu_option_pos == 3) { // Options option.
            // printf("Options");
            opt.options_run(pad, lcd); // Runs the options screen loop.
        }
        if (menu_option_pos == 4) { // High Scores option.
            // printf("High Scores");
            high.highscores_run(pad, lcd, banana); // Runs the highscores screen loop.
        }
    }
}

// Prints the main menu, with options and the selector arrow.
void print_menu() {
    lcd.clear();
    lcd.printString("Main Menu",19,0);
    lcd.printString("Start Game",8,1);
    lcd.printString("Controls",8,2);
    lcd.printString("Instructions",8,3);
    lcd.printString("Options",8,4);
    lcd.printString("High Scores",8,5);
    lcd.drawSprite(0,arrow_pos,7,7,(int *)menu_arrow);
    lcd.refresh();
}
 
// Prints basic information about the game, and plays title screen.
void welcome() {
    lcd.clear();
    lcd.drawSprite(24,0,36,34,(int *)menu_dk_face); // Donkey Kong sprite for main menu
    lcd.printString("  Donkey Kong",0,5); // Game title.
    lcd.refresh();
    wait(4.0); 
    lcd.clear();
    lcd.printString("  Created",0,0); // Information about creator.
    lcd.printString("  By",0,1);
    lcd.printString("  Kern Fowler",0,3);
    lcd.printString("  201116686",0,4);
    lcd.refresh();
    wait(4.0);
}