#ifndef INSTRUCTIONS_H
#define INSTRUCTIONS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Instructions Class
*@brief This class is for the instructions menu screen.
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/

class Instructions {

public:
/** Instructions Constructor 
@brief Builds my default Instructions contructor.
@details This does not have any setup. 
*/
Instructions();
/** Instructions Destructor 
@brief Builds my default Instructions destructor.
@details This does not have any setup. 
*/
~Instructions();
// Mutators

/** 
*@brief Prints the Instructions menu.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@return None.
*@details Prints various text to screen relating to how to play the game.
*@code
void Instructions::instructions_run(Gamepad &pad, N5110 &lcd) {
    wait_ms(250);
    while (pad.check_event(Gamepad::BACK_PRESSED) == false) { // Continues to show this screen until BACK button pressed.
        //printf("Instructions State");
        lcd.clear();
        lcd.printString("Instructions",7,0);
        lcd.printString("Move DonkeyKong",0,2);
        lcd.printString("left or right",0,3);
        lcd.printString("to collect ",0,4);
        lcd.printString("Bananas",0,5);
        lcd.refresh();
        wait(4); // Changes to next screen after 4 seconds.
        lcd.clear();
        lcd.printString("Instructions",7,0);
        lcd.printString("Avoid the ",0,2);
        lcd.printString("falling ",0,3);
        lcd.printString("Barrels ",0,4);
        lcd.refresh();
        wait(4); // Loops through both screens. 
    }
}
@endcode
*/
void instructions_run(Gamepad &pad, N5110 &lcd);
};

#endif