#ifndef HIGHSCORES_H
#define HIGHSCORES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Banana.h"

/** External variables used inside and out of the class. */
extern int HighScore_1;
extern int HighScore_2;
extern int HighScore_3;
extern int HighScore_4;

/** HighScores Class
*@brief This class is keeping track of any highscores.
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/

class HighScores {

public:
/** HighScores Constructor 
@brief Builds my default highscores constructor.
@details This does not have any setup. 
*/
HighScores();
/** HighScores Destructor 
@brief Builds my default highscores destructor.
@details This does not have any setup. 
*/
~HighScores();
// Mutators
/** 
*@brief Controls the Highscores menu.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param banana The Banana class is used.
*@return None.
*@details Prints the High Score Menu.
*@code 
void HighScores::highscores_run(Gamepad &pad, N5110 &lcd, Banana &banana) { 
    wait_ms(250);
    while (pad.check_event(Gamepad::BACK_PRESSED) == false) { // Continues to show this screen until BACK button pressed.
        //printf("High Score State");
        lcd.clear();
        lcd.printString("High Scores",12,0);
        highscores_list(pad, lcd, banana);
        lcd.refresh();
        wait_ms(1.0f/24);
    }
}
@endcode
*/
void highscores_run(Gamepad &pad, N5110 &lcd, Banana &banana);
/** 
*@brief Adds a new highscore.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param banana The Banana class is used.
*@return None.
*@details Edits various highscores based on if player has scored a new record.
*@code 
void HighScores::highscores_new(Gamepad &pad, N5110 &lcd, Banana &banana) {
    if (score >= HighScore_1) {
        HighScore_1 = score;
    }
    else if (score >= HighScore_2) {
        HighScore_2 = score;
    }
    else if (score >= HighScore_3) {
        HighScore_3 = score;
    }
    else if (score >= HighScore_4) {
        HighScore_4 = score;
    }
}
@endcode
*/
void highscores_new(Gamepad &pad, N5110 &lcd, Banana &banana);
/** 
*@brief Lists all current highscores.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param banana The Banana class is used.
*@return None.
*@details Keeps and prints a list of all highscores.
*@code 
void HighScores::highscores_list(Gamepad &pad, N5110 &lcd, Banana &banana){
    lcd.printString("1st:",0,2);
    lcd.printString("2nd:",0,3);
    lcd.printString("3rd:",0,4);
    lcd.printString("4th:",0,5);
    char buffer1[14]; // Shows 1st highscore on screen.
    sprintf(buffer1,"%i",HighScore_1);
    lcd.printString(buffer1,40,2);
    char buffer2[14]; // Shows 2nd highscore on screen.
    sprintf(buffer2,"%i",HighScore_2);
    lcd.printString(buffer2,40,3);
    char buffer3[14]; // Shows 3rd highscore on screen.
    sprintf(buffer3,"%i",HighScore_3);
    lcd.printString(buffer3,40,4);
    char buffer4[14]; // Shows 4th highscore on screen.
    sprintf(buffer4,"%i",HighScore_4);
    lcd.printString(buffer4,40,5);
    lcd.refresh();
}
@endcode
*/
void highscores_list(Gamepad &pad, N5110 &lcd, Banana &banana);
};

#endif