#ifndef CONTROLS_H
#define CONTROLS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Controls Class
*@brief This class is for the controls menu screen
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/

class Controls {

public:
/** Controls Constructor 
@brief Builds my default Controls contructor.
@details This does not have any setup. 
*/
Controls();
/** Controls Destructor 
@brief Builds my default Controls Destructor.
@details This does not have any setup. 
*/   
~Controls();
// Mutators 

/** 
*@brief Prints the Controls menu.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@return None.
*@details Prints various text to screen relating to the game controls.
*@code
void Controls::controls_run(Gamepad &pad, N5110 &lcd) {
    wait_ms(250);
    while (pad.check_event(Gamepad::BACK_PRESSED) == false) { // Continues to show this screen until BACK button pressed.
        //printf("Control State");
        lcd.clear();
        lcd.printString("Controls",19,0);
        lcd.printString("Move Joystick ",0,2);
        lcd.printString("Left or Right ",0,3);
        lcd.printString("   to move    ",0,4);
        lcd.printString(" Donkey Kong  ",0,5);
        lcd.refresh();
        wait_ms(1.0f/24);
    }
}
@endcode
*/
void controls_run(Gamepad &pad, N5110 &lcd);
};

#endif