/*
ELEC2645 Project
Barrel.cpp
Class file for Barrel in Donkey Kong game.
*/

#include "Barrel.h"

// Constructor - Doesn't require any setup.
Barrel::Barrel()
{

}

// Deconstructor - Doesn't require any setup.
Barrel::~Barrel()
{

}

// External variables to be used inside and out of the class.
int barrel_x = 30; // Barrel's coordinates.
int barrel_y = 0;
int barrel_speed = 0; // Barrel's dropspeed.
int barrel_min = 0; // Barrel's min and max spawn ppositions - limited by screen size.
int barrel_max = 76;
float barrel_time = 0; // Time Barrel has been on screen, for score.
int running = 1; // Player score.

int game_barrel[4][8] = { // Barrel sprite.
    {0,1,1,1,1,1,1,0,},
    {1,1,1,1,1,1,1,1,},
    {1,1,1,1,1,1,1,1,},
    {0,1,1,1,1,1,1,0,},
};

// Spawns a barrel at a random x location, then slowly falls down screen. When reaches bottom it restarts. If collision with player leads to gameover.
void Barrel::barrel_drop(Gamepad &pad, N5110 &lcd, Donkey &dky) {
    lcd.drawSprite(barrel_x,barrel_y,4,8,(int *)game_barrel); // Draws the barrel sprite on screen with correct coordinates.
    lcd.refresh();
    wait_ms(50);
    barrel_y = barrel_y + 1 + barrel_time;
    if (barrel_y > 44) { // If barrel reaches bottom of the screen, the resets.
        barrel_y = 0;
        barrel_x = rand() % (barrel_max + 1 - barrel_min) + barrel_min;
        barrel_time = barrel_time + 0.1; // Moves barrel slowly down screen.
    }
    if ((barrel_y >= 34) & ((barrel_x + 7) >= donkeykong_x) & (barrel_x <= (donkeykong_x + 15))) { // If barrel collides with player then sets running to 0, causing gameover.
        running = 0;
        //printf("Barrel Hit")
    }
}