#ifndef BANANA_H
#define BANANA_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Barrel.h"
#include "Donkey.h"
#include "Options.h"

/** External variables used inside and out of the class. */
extern int banana_x;
extern int banana_y;
extern int banana_speed;
extern int banana_min;
extern int banana_max;
extern int banana_time;
extern int score;

/** Banana Class
*@brief This class is for spawning the banana, it will float down the screen. Collision with the player will add points.
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/

class Banana {

public:
/** Banana Constructor 
@brief Builds my default Banana contructor.
@details This does not have any setup. 
*/
Banana();
/** Banana Destructor 
@brief Builds my default Banana destructor.
@details This does not have any setup. 
*/
~Banana();
// Mutators

/** 
*@brief Spawns the banana
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param barrel The Barrel class is used.
*@param dky The Donkey class is used.
*@param opt The Options class is used.
*@return None.
*@details Spawns a banana at a random x location, then slowly falls down screen. When reaches bottom or collected by player it restarts.
*@code 
void Banana::banana_drop(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt) {
    if (((banana_x + 8) >= barrel_x) & (banana_x <= (barrel_x + 16)) & (banana_y <= 4)) { // Makes sure not in same position as barrel sprite.
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min; // Random x spawn coordinate.
    }
    lcd.drawSprite(banana_x,banana_y,8,8,(int *)game_banana); // Draws the banana sprite on screen with the correct coordinates.
    char buffer[14]; // Shows score on screen.
    sprintf(buffer,"%i",score); 
    lcd.printString(buffer,60,0);
    lcd.refresh();
    wait_ms(50);
    banana_y = banana_y + 1 + banana_time; // Moves banana slowly down screen.
    if (banana_y > 44) { // If banana reaches the bottom of screen, then resets.
        banana_y = 0;
        banana_time = banana_time + 0.1;
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min;
    }
    if ((banana_y >= 34) & ((banana_x + 7) >= donkeykong_x) & (banana_x <= (donkeykong_x + 15))) { // If banana collides with player sprite, then adds to score and resets.
        score = score + 10 + banana_time;
        banana_hit(pad, lcd, barrel, dky, opt);
        banana_y = 0;
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min;
        //printf("Banana Hit - Score: %d \n", score); // Prints running score to external computer screen.
        //printf("Banana x  %d \n", banana_x);
        //printf("Barrel x  %d \n", barrel_x);
    }
}
@endcode
*/
void banana_drop(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt);
/** 
*@brief Plays music on hit
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param barrel The Barrel class is used.
*@param dky The Donkey class is used.
*@param opt The Options class is used.
*@return None.
*@details Plays a tone when banana is collected.
*@code 
void Banana::banana_hit(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt) {
    if (opt_volume == 1) {
        pad.tone(2400, 0.2);
    }
}
@endcode
*/
void banana_hit(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt);
};

#endif