/*
ELEC2645 Project
Banana.cpp
Class file for Banana in Donkey Kong game.
*/

#include "Banana.h"

// Constructor - Doesn't require any setup.
Banana::Banana()
{

}

// Deconstructor - Doesn't require any setup.
Banana::~Banana()
{

}

// External variables to be used inside and out of the class.
int banana_x = 0; // Banana's coordinates.
int banana_y = 0;
int banana_speed = 0; // Banana's dropspeed.
int banana_min = 0; // Banana's min and max spawn positions - limited by screen size.
int banana_max = 76;
int banana_time = 0; // Time Banana has been on screen, for score.
int score = 0; // Player score.

int game_banana[8][8] = { // Banana sprite.
    {0,0,0,0,0,0,1,0,},
    {0,0,0,0,0,1,1,1,},
    {0,0,0,0,0,1,1,1,},
    {0,0,0,0,1,1,1,1,},
    {0,0,0,1,1,1,1,0,},
    {0,1,1,1,1,1,1,0,},
    {1,1,1,1,1,1,0,0,},
    {0,1,1,1,0,0,0,0,},
};

// Spawns a banana at a random x location, then slowly falls down screen. When reaches bottom or collected by player it restarts.
void Banana::banana_drop(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt) {
    if (((banana_x + 8) >= barrel_x) & (banana_x <= (barrel_x + 16)) & (banana_y <= 4)) { // Makes sure not in same position as barrel sprite.
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min; // Random x spawn coordinate.
    }
    lcd.drawSprite(banana_x,banana_y,8,8,(int *)game_banana); // Draws the banana sprite on screen with the correct coordinates.
    char buffer[14]; // Shows score on screen.
    sprintf(buffer,"%i",score); 
    lcd.printString(buffer,60,0);
    lcd.refresh();
    wait_ms(50);
    banana_y = banana_y + 1 + banana_time; // Moves banana slowly down screen.
    if (banana_y > 44) { // If banana reaches the bottom of screen, then resets.
        banana_y = 0;
        banana_time = banana_time + 0.1;
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min;
    }
    if ((banana_y >= 34) & ((banana_x + 7) >= donkeykong_x) & (banana_x <= (donkeykong_x + 15))) { // If banana collides with player sprite, then adds to score and resets.
        score = score + 10 + banana_time;
        banana_hit(pad, lcd, barrel, dky, opt);
        banana_y = 0;
        banana_x = rand() % (banana_max + 1 - banana_min) + banana_min;
        //printf("Banana Hit - Score: %d \n", score); // Prints running score to external computer screen.
        //printf("Banana x  %d \n", banana_x);
        //printf("Barrel x  %d \n", barrel_x);
    }
}

void Banana::banana_hit(Gamepad &pad, N5110 &lcd, Barrel &barrel, Donkey &dky, Options &opt) {
    if (opt_volume == 1) {
        pad.tone(2400, 0.2);
    }
}