#ifndef DONKEY_H
#define DONKEY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** External variables used inside and out of the class. */
extern int donkeykong_x;
extern int donkeykong_y;
extern int donkey_kong_speed;
extern int donkey_direction;

/** Donkey Class
*@brief This class is for spawning the player controlled model Donkey Kong.
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/

class Donkey {

public:
/** Donkey Constructor
@brief Builds my default Donkey Kong constructor.
@details This does not have any setup. 
*/
Donkey();
/** Donkey Destructor 
@brief Builds my default Donkey Kong destructor.
@details This does not have any setup. 
*/
~Donkey();
// Mutators

/** 
*@brief Spawns Donkey Kong model.
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@return None.
*@details Creates the player controlled unit Donkey Kong, then moves it left or right based on joystick input. Points on collision with bananas. Gameover on collision with barrels.
*@code
void Donkey::donkeykong_movement(Gamepad &pad, N5110 &lcd) {
    donkey_direction = pad.get_direction();
        if (donkey_direction == NE || donkey_direction == E || donkey_direction == SE) { // If joystick moved right, the right position sprite will be loaded and donkey kong will move right.
            donkeykong_x = donkeykong_x + 3;
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_walking_right_1);
        } 
        else if (donkey_direction == NW || donkey_direction == W || donkey_direction == SW) { // If joystick moved left, the left position sprite will be loaded and donkey kong will move left.
            donkeykong_x = donkeykong_x - 3;
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_walking_left_1);
        } 
        else { // If joystick not moved, then stationary sprite will be loaded and no movement occurs.
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_stationary); 
        }
        lcd.refresh();
        if (donkeykong_x > 68) { // Stops donkey kong model going off screen. 
            donkeykong_x = 68;
        }
        if (donkeykong_x < 0) {
            donkeykong_x = 0;
        }
}
@endocde
*/
void donkeykong_movement(Gamepad &pad, N5110 &lcd);
};

#endif