/*
ELEC2645 Project
Donkey.cpp
Class file for Donkey Kong in Donkey Kong game.
*/

#include "Donkey.h"

// Constructor - Doesn't require any setup.
Donkey::Donkey()
{

}

// Deconstructor - Doesn't require any setup.
Donkey::~Donkey()
{

}

// External variables to be used inside and out of the class.
int donkeykong_x = 0; // Donkey Kong's coordinates.
int donkeykong_y = 34;
int donkey_kong_speed = 10; // Donkey Kong's dropspeed.
int donkey_direction; // Joystick input.

int game_dk_walking_right_1[14][16] = { // Donkey Kong moving right sprite
    {0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,},
    {0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,},
    {0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,},
    {0,0,0,0,1,1,0,0,0,1,0,0,1,0,1,0,},
    {0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,},
    {0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,},
    {0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,},
    {1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,1,},
    {1,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,},
    {1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,},
    {1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,},
    {1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,},
};

int game_dk_walking_left_1[14][16] = { // Donkey Kong moving left sprite
    {0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,},
    {0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,},
    {0,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,},
    {1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,},
    {1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,},
    {0,1,0,1,0,0,1,0,0,0,1,1,0,0,0,0,},
    {0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,},
    {0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,},
    {0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,},
    {1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,1,},
    {1,0,0,1,0,0,1,1,1,0,0,0,1,0,0,1,},
    {1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,},
    {1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,},
    {1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,},
};

int game_dk_stationary[14][16] = { // Donkey Kong stationary sprite
    {0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,},
    {0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,},
    {0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,},
    {0,0,0,1,0,1,1,0,1,1,0,1,0,0,0,0,},
    {0,0,1,1,0,1,1,0,1,1,0,0,1,0,0,0,},
    {0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,},
    {0,0,1,0,1,0,0,0,0,0,1,0,0,1,0,0,},
    {0,1,0,0,0,1,1,1,1,1,0,0,0,0,1,0,},
    {0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,},
    {1,0,0,1,0,1,0,0,0,0,1,0,1,0,0,1,},
    {1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,1,},
    {1,0,1,0,1,0,0,1,1,0,0,1,0,1,0,1,},
    {0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,},
};

// Creates the player controlled unit Donkey Kong, then moves it left or right based on joystick input. Points on collision with bananas. Gameover on collision with barrels.
void Donkey::donkeykong_movement(Gamepad &pad, N5110 &lcd) {
    donkey_direction = pad.get_direction();
        if (donkey_direction == NE || donkey_direction == E || donkey_direction == SE) { // If joystick moved right, the right position sprite will be loaded and donkey kong will move right.
            donkeykong_x = donkeykong_x + 3;
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_walking_right_1);
        } 
        else if (donkey_direction == NW || donkey_direction == W || donkey_direction == SW) { // If joystick moved left, the left position sprite will be loaded and donkey kong will move left.
            donkeykong_x = donkeykong_x - 3;
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_walking_left_1);
        } 
        else { // If joystick not moved, then stationary sprite will be loaded and no movement occurs.
            lcd.drawSprite(donkeykong_x,donkeykong_y,14,16,(int *)game_dk_stationary); 
        }
        lcd.refresh();
        if (donkeykong_x > 68) { // Stops donkey kong model going off screen. 
            donkeykong_x = 68;
        }
        if (donkeykong_x < 0) {
            donkeykong_x = 0;
        }
}