#ifndef BARREL_H
#define BARREL_H

#include "mbed.h"
#include "N5110.h"
#include "Barrel.h"
#include "Donkey.h"

/** External variables used inside and out of the class. */
extern int barrel_x;
extern int barrel_y;
extern int barrel_speed;
extern int barrel_min;
extern int barrel_max;
extern float barrel_time;
extern int running;

/** Barrel Class
*@brief This class is for spawning the barrel, it will float down the screen. Collision with the player will cause gameover.
*@author Kern Fowler
*@version 1.0
*@date May 2019
*/
    
class Barrel { 

public:
/** Barrel Constructor 
@brief Builds my default Barrel contructor.
@details This does not have any setup. 
*/
Barrel();
/** Barrel Destructor 
@brief Builds my default Barrel dentructor.
@details This does not have any setup. 
*/
~Barrel();
// Mutators

/** 
*@brief Spawns the barrel
*@param pad The Gamepad class is used.
*@param lcd The N5110 class is used.
*@param dky The Donkey class is used.
*@return None.
*@details Spawns a barrel at a random x location, then slowly falls down screen. When reaches bottom it restarts. If collision with player leads to gameover.
*@code
void Barrel::barrel_drop(Gamepad &pad, N5110 &lcd, Donkey &dky) {
    lcd.drawSprite(barrel_x,barrel_y,4,8,(int *)game_barrel); // Draws the barrel sprite on screen with correct coordinates.
    lcd.refresh();
    wait_ms(50);
    barrel_y = barrel_y + 1 + barrel_time;
    if (barrel_y > 44) { // If barrel reaches bottom of the screen, the resets.
        barrel_y = 0;
        barrel_x = rand() % (barrel_max + 1 - barrel_min) + barrel_min;
        barrel_time = barrel_time + 0.1; // Moves barrel slowly down screen.
    }
    if ((barrel_y >= 34) & ((barrel_x + 7) >= donkeykong_x) & (barrel_x <= (donkeykong_x + 15))) { // If barrel collides with player then sets running to 0, causing gameover.
        running = 0;
        //printf("Barrel Hit")
    }
}
@endcode
*/
void barrel_drop(Gamepad &pad, N5110 &lcd, Donkey &dky);
};

#endif