/*
ELEC2645 Project
HighScores.cpp
Class file for HighScores in Donkey Kong game.
*/

#include "HighScores.h"

// Constructor - Doesn't require any setup.
HighScores::HighScores()
{

}

// Deconstructor - Doesn't require any setup.
HighScores::~HighScores()
{
    
}

// External variables to be used inside and out of the class.
int HighScore_1 = 0;
int HighScore_2 = 0;
int HighScore_3 = 0;
int HighScore_4 = 0;

// Prints the High Score Menu.
void HighScores::highscores_run(Gamepad &pad, N5110 &lcd, Banana &banana) { 
    wait_ms(250);
    while (pad.check_event(Gamepad::BACK_PRESSED) == false) { // Continues to show this screen until BACK button pressed.
        //printf("High Score State");
        lcd.clear();
        lcd.printString("High Scores",12,0);
        highscores_list(pad, lcd, banana);
        lcd.refresh();
        wait_ms(1.0f/24);
    }
}

// Edits various highscores based on if player has scored a new record.
void HighScores::highscores_new(Gamepad &pad, N5110 &lcd, Banana &banana) {
    if (score >= HighScore_1) {
        HighScore_1 = score;
    }
    else if (score >= HighScore_2) {
        HighScore_2 = score;
    }
    else if (score >= HighScore_3) {
        HighScore_3 = score;
    }
    else if (score >= HighScore_4) {
        HighScore_4 = score;
    }
}

// Keeps and prints a list of all highscores.
void HighScores::highscores_list(Gamepad &pad, N5110 &lcd, Banana &banana){
    lcd.printString("1st:",0,2);
    lcd.printString("2nd:",0,3);
    lcd.printString("3rd:",0,4);
    lcd.printString("4th:",0,5);
    char buffer1[14]; // Shows 1st highscore on screen.
    sprintf(buffer1,"%i",HighScore_1);
    lcd.printString(buffer1,40,2);
    char buffer2[14]; // Shows 2nd highscore on screen.
    sprintf(buffer2,"%i",HighScore_2);
    lcd.printString(buffer2,40,3);
    char buffer3[14]; // Shows 3rd highscore on screen.
    sprintf(buffer3,"%i",HighScore_3);
    lcd.printString(buffer3,40,4);
    char buffer4[14]; // Shows 4th highscore on screen.
    sprintf(buffer4,"%i",HighScore_4);
    lcd.printString(buffer4,40,5);
    lcd.refresh();
}