/*
ELEC2645 Project
GameEngine.cpp
Class file for GameEngine in Donkey Kong game.
*/

#include "GameEngine.h"

// Constructor - Doesn't require any setup.
GameEngine::GameEngine()
{

}

// Deconstructor - Doesn't require any setup.
GameEngine::~GameEngine()
{

}

// Runs the main functions of the game in correct order.
void GameEngine::gameengine_run(Gamepad &pad, N5110 &lcd, Barrel &barrel, Banana &banana, Donkey &dky, Options &opt) {
    wait_ms(250);
    // Sets key variables back to default value when game first ran.
    barrel_x = 0; 
    barrel_y = 0;
    banana_x = 0;
    banana_y = 0;
    running = 1;
    banana_time = 0;
    barrel_time = 0;
    score = 0;
    while (running == 1) { // Main game loop, continues until game over occurs.
        //printf("Game State");
        lcd.clear();
        dky.donkeykong_movement(pad, lcd); // Calls Donkey Kong model section of game.
        barrel.barrel_drop(pad, lcd, dky); // Calls Barrel model section of game.
        banana.banana_drop(pad, lcd, barrel, dky, opt); // Calls Banana model section of game.
        //printf("state %d", running);
        lcd.refresh(); // Reloads screen on every cycle, controlled by fps. Default set to 24.
        wait_ms(1.0f/24);
    }
}

// Prints the gameover screen. Prints various text, including total player score.
void GameEngine::gameengine_score(Gamepad &pad, N5110 &lcd, Banana &banana, HighScores &high) {
    lcd.clear();
    lcd.printString("Game Over!",14,0);
    lcd.printString("Score:",0,2);
    char buffer[14]; // Shows final score on screen.
    sprintf(buffer,"%i",score);
    lcd.printString(buffer,40,2);
    high.highscores_new(pad, lcd, banana); // Checks to see if new high score is obtained.
    lcd.refresh();
    wait(5);
}