#include "MQTTClient.h"
#include "MQTTNetwork.h"
#include "ISM43362Interface.h"
#include "MQTTmbed.h"

int arrivedcount = 0;
Serial pc(SERIAL_TX, SERIAL_RX);

ISM43362Interface wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO, MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET, MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);

int main(int argc, char* argv[])
{
    pc.baud(115200);
    int cnt = 0;
    float version = 0.6;
    char* topic = "test";
    const char* hostname = "192.168.0.54";
    int port = 1883;
    wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2,0);
    NetworkInterface* network = &wifi;
    MQTTNetwork mqttNetwork(network);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    mqttNetwork.connect(hostname, port);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "valami";
    data.username.cstring = "";
    data.password.cstring = "";
    client.connect(data);
    //client.subscribe(topic, MQTT::QOS0, messageArrived);
    MQTT::Message message;
    char buf[100];
    sprintf(buf, "Hello World!");
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    while (true)
    {
        client.publish(topic, message);
        wait(1);
    }
    
    return 0;
}