#include "mbed.h"
#include "ToggleDigitalOut.h"

ToggleDigitalOut :: ToggleDigitalOut(PinName pin) : DigitalOut(pin){
    ticker = 0;
}
ToggleDigitalOut :: ~ToggleDigitalOut(){
    stopToggling();
}
void ToggleDigitalOut :: toggle(void){
    write(!read());
}
void ToggleDigitalOut :: toggling(float span){
    stopToggling();
    ticker = new Ticker();
    ticker->attach(this,&ToggleDigitalOut::toggle,span);
}
void ToggleDigitalOut :: stopToggling(void){
    if(ticker){
        ticker->detach();
        delete ticker;
    }
    ticker = 0;
}
