#include "mbed.h"
#include "BMP180.h"
#include "ble/BLE.h"

BMP180 baro(D14, D15);
uint8_t* bufTemp;
uint8_t* bufPress;
uint8_t* bufHum;
float tmpTemp=0.0;
float tmpPress=0.0;
float tmpHum = 0.0;

Ticker updateValue;
bool flagCapt = true;
AnalogIn Pot(A0);

uint16_t customServiceUUID  = 0xA000;
uint16_t TempCharUUID       = 0xA001;
uint16_t PressCharUUID      = 0xA002;
uint16_t HumCharUUID        = 0xA003;

const static char     DEVICE_NAME[]        = "Capteur"; // change this
static const uint16_t uuid16_list[]        = {0xFFFF}; //Custom UUID, FFFF is reserved for development

/* Set Up custom Characteristics */
static uint8_t TempValue[4] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(TempValue)> TempChar(TempCharUUID, TempValue);

static uint8_t PressValue[4] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(PressValue)> PressChar(PressCharUUID, PressValue);

static uint8_t HumValue[4] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(HumValue)> HumChar(HumCharUUID, HumValue);

/* Set up custom service */
GattCharacteristic *characteristics[] = {&TempChar, &PressChar, &HumChar};
GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

/*
 *  Callback when the redbearlab has to update its values
*/
void callbackUpdate() {
    flagCapt = true;
}

/*
 *  Restart advertising when phone app disconnects
*/
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *)
{
    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising();
}

/*
 * Initialization callback
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;
    
    if (error != BLE_ERROR_NONE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); // BLE only, no classic BT
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // advertising type
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME)); // add name
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list)); // UUID's broadcast in advertising packet
    ble.gap().setAdvertisingInterval(100); // 100ms.

    /* Add our custom service */
    ble.addService(customService);

    /* Start advertising */
    ble.gap().startAdvertising();
}

/*
 *  Main loop
*/
int main(void)
{
    updateValue.attach_us(&callbackUpdate,100000);
    
    /* initialize stuff */
    printf("\n\r********* Starting Main Loop *********\n\r");
    
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) { /* spin loop */ }

    /* Infinite loop waiting for BLE*/
    while (true) {
        /* Check if update needed*/
        if(flagCapt == true){
            flagCapt = false;
            
            /* Get the new values*/
            baro.normalize();
            tmpTemp = baro.read_temperature();
            tmpPress = baro.read_pressure();
            tmpHum = Pot;
            
            /* Convert float into arrays of 4 uint8_t*/
            bufTemp = reinterpret_cast<uint8_t*>(&tmpTemp);
            bufPress = reinterpret_cast<uint8_t*>(&tmpPress);
            bufHum = reinterpret_cast<uint8_t*>(&tmpHum);
            
            /* Update values into GattCharacteristic*/
            ble.updateCharacteristicValue(TempChar.getValueAttribute().getHandle(), bufTemp, 4);
            ble.updateCharacteristicValue(PressChar.getValueAttribute().getHandle(), bufPress, 4);
            ble.updateCharacteristicValue(HumChar.getValueAttribute().getHandle(), bufHum, 4);
        }else{    
            ble.waitForEvent(); /* Save power */
        }
    }
}