#include "mbed.h"

I2C link(I2C_SDA, I2C_SCL);
const int addr = 0x7C;

void Init(void){
    char cmd[2];
    cmd[0] = 0x80;
    cmd[1] = 0x3C;
    link.write(addr,cmd,2);
    wait_us(100);
    
    cmd[1] = 0x0F;
    link.write(addr,cmd,2);
    wait_us(100);
    
    cmd[1] = 0x01;
    link.write(addr,cmd,2);
    wait_ms(2);
    
    cmd[1] = 0x06;
    link.write(addr,cmd,2);
    wait_us(100);
}

void initRGB(void){
    char cmd[2];
    
    cmd[0] = 0x00;
    cmd[1] = 0x00;
    link.write(0xC4,cmd,2);
    wait_us(100);
    
    cmd[0] = 0x01;
    cmd[1] = 0x00;
    link.write(0xC4,cmd,2);
    wait_us(100);
    
    cmd[0] = 0x08;
    cmd[1] = 0xAA;
    link.write(0xC4,cmd,2);
    wait_us(100);
}

void setup(char R,char G, char B){
    char cmd[2];
    
    cmd[0] = 0x02;
    cmd[1] = B;
    link.write(0xC4,cmd,2);
    wait_us(100);
    
    cmd[0] = 0x03;
    cmd[1] = G;
    link.write(0xC4,cmd,2);
    wait_us(100);
    
    cmd[0] = 0x04;
    cmd[1] = R;
    link.write(0xC4,cmd,2);
    wait_us(100);
}


int main(void){
    AnalogIn Pot(A0);
    
    char data[12];
    char R,G,B;
    
    Init();
    initRGB();
    
    data[0] = 0x40;
    data[1] = 'H';
    data[2] = 'e';
    data[3] = 'l';
    data[4] = 'l';
    data[5] = 'o';
    data[6] = ' ';
    data[7] = 'W';
    data[8] = 'o';
    data[9] = 'r';
    data[10] = 'l';
    data[11] = 'd';
    
    link.write(addr,data,12);
    
    while(1){
        if( (Pot>0.2f) & (Pot<=0.4f)){
            R = 0xFF;
            G = 0x00;
            B = 0x00;
        }else if( (Pot>0.4f) & (Pot<=0.6f) ){
            R = 0x00;
            G = 0xFF;
            B= 0x00;   
        }else if( (Pot>0.6f) ){
            R = 0x00;
            G = 0x00;
            B = 0xFF;
        }else{
            R = 0x00;
            G = 0x00;
            B = 0x00;
        }
        setup(R,G,B);
    }
}