#include "mbed.h"

I2C link(I2C_SDA, I2C_SCL);
const int addr = 0x7C;

void Init(void){
    char cmd[2];
    cmd[0] = 0x80;
    cmd[1] = 0x3F;
    link.write(addr,cmd,2);
    wait_us(100);
    
    cmd[1] = 0x0F;
    link.write(addr,cmd,2);
    wait_us(100);
    
    cmd[1] = 0x01;
    link.write(addr,cmd,2);
    wait_ms(2);
    
    cmd[1] = 0x06;
    link.write(addr,cmd,2);

    cmd[1] = 0xC0;
    link.write(addr,cmd,2);
    wait_us(100);
}


int main(void){
    char data[3];
    
    data[0] = 0x40;
    data[1] = '0';
    data[2] = '0';
    
    while(1){
        Init();
        link.write(addr,data,3);
        if (data[2] < '9'){
            data[2]++;
        }else{
            data[2] = '0';
            if(data[1] < '5'){
                data[1]++;
            }else{
                data[1] = '0';   
            }
        }
        wait(0.5);
    }
}