#include         "mbed.h"
#include          "QEI.h"
#include "ClockControl.h"

//Number of pulses in one revolution
#define  PULSE 6144  //12(encorder_plse) * 16(gear_head) * 32(wheel)
#define LENGTH    4  //servo_number

Serial        device( p28, p27 );   //serial_PC
Serial         servo( p9, p10 );    //serial_servo
QEI            r_enc(  p6,  p5, NC, PULSE, QEI :: X4_ENCODING );    //encorder(right_motor)
QEI            l_enc( p18, p17, NC, PULSE, QEI :: X4_ENCODING );    //encorder(left_motor)
PwmOut     right_pwm( p22 );    //PWM(right_motor)
PwmOut      left_pwm( p21 );    //PWM(left_motor)
DigitalOut   right_P( p7 );     //H bridge(right_motor)
DigitalOut   right_N( p8 );     //H bridge(right_motor)
DigitalOut    left_P( p15 );    //H bridge(left_motor)
DigitalOut    left_N( p16 );    //H bridge(left_motor)
DigitalOut    enable( p19 );    //Enable_pin(motor_driver)
PwmOut          led1( p23 );    //LED for observation of the robot
PwmOut          led2( p24 );    //LED for observation of the robot

//motor.h
void    qei( void );
void   move_f( double, double );
void   move_b( double, double );
void   turn_r( double, double );
void   turn_l( double, double );
void   stop( void );

//servo.h
short ID_num[LENGTH] = { 0x01, 0x02, 0x03, 0x04 };
short degree[LENGTH] = { 0, 1500, -1500, 0 };

void control_servo( void );
void       cal_deg( short, short *, short * );
void          save( short );
short      cal_sum( short *, int );
void        id_set( void );